<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Employee;

class AbsensiController extends Controller
{
    public function index()
    {
        $absensi = Employee::all();
        $employees = Employee::all();

        return view('employee.absensi', [
            'title' => 'Absensi',
            'active' => 'absensi',
            'absensi' => $absensi,
            'employees' => $employees
        ]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'employee_id' => 'required|numeric|exists:employee,id', // use 'employee' table
            'date' => 'required|date',
            'status' => 'required|in:masuk,tidak_masuk',
        ]);

        $employee = Employee::find($request->employee_id);
        if ($employee) {
            $employee->update([
                'date' => $request->date,
                'status' => $request->status,
            ]);

            return redirect('/absensi')->with('success', 'Attendance recorded successfully!');
        } else {
            return redirect('/absensi')->with('error', 'Employee not found!');
        }
    }
}
