@extends('dashboard.layouts.main')
@section('container')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Penggajian</h1>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-default rounded-0 shadow">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                            <h3 class="card-title">Penggajian</h3>
                        </div>
                    </div>
                    <div class="clear:both"></div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 table-responsive">
                            <table id="supplierList" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Current Gaji / Bulan</th>
                                        <th>Update Gaji</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($employees as $employee)
                                        <tr>
                                            <td><b>{{ $employee->id }}</b></td>
                                            <td>{{ $employee->nama }}</td>
                                            <td>Rp. {{ number_format(optional($employee->currentGaji)->gaji, 0, ',', '.') }}</td>
                                            <td>
                                                <a class="badge bg-warning" data-bs-toggle="modal" data-bs-target="#updateGajiModal{{ $employee->id }}"><i class="bi bi-pencil" style="cursor: pointer;"></i></a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @foreach ($employees as $employee)
    <div class="modal fade" id="updateGajiModal{{ $employee->id }}" tabindex="-1" aria-labelledby="updateGajiModalLabel{{ $employee->id }}" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="updateGajiModalLabel{{ $employee->id }}">Update Gaji</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="updateGajiForm{{ $employee->id }}" action="{{ route('penggajian.update', $employee->id) }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label for="gaji" class="form-label">Gaji / Bulan</label>
                            <input type="number" class="form-control @error('gaji') is-invalid @enderror" id="gaji" name="gaji" required value="{{ old('gaji') }}" placeholder="Nominal Gaji">
                            @error('gaji')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Update Gaji</button>
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    @endforeach
@endsection
