@extends('dashboard.layouts.main')

@section('container')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Laba Rugi</h1>
    </div>

    <form action="{{ route('laporan.laba-rugi') }}" method="GET" class="mb-4">
        <div class="row">
            <div class="col-md-3">
                <select name="month" class="form-control">
                    @for ($m = 1; $m <= 12; $m++)
                        <option value="{{ $m }}" {{ $m == $selectedMonth ? 'selected' : '' }}>
                            {{ DateTime::createFromFormat('!m', $m)->format('F') }}
                        </option>
                    @endfor
                </select>
            </div>
            <div class="col-md-3">
                <select name="year" class="form-control">
                    @for ($y = date('Y'); $y >= date('Y') - 2; $y--)
                        <option value="{{ $y }}" {{ $y == $selectedYear ? 'selected' : '' }}>
                            {{ $y }}
                        </option>
                    @endfor
                </select>
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-primary">Filter</button>
            </div>
        </div>
    </form>

    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    Pendapatan
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        @foreach ($pendapatan as $item)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>{{ $item->customer->nama }}</span>
                                <span>Tanggal: {{ $item->created_at->format('d-m-Y') }}</span>
                                <span>Total: Rp. {{ number_format($item->harga_total, 0, ',', '.') }}</span>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-danger text-white">
                    Beban
                </div>
                <div class="card-body">
                    <h5>Pembelian</h5>
                    <ul class="list-group">
                        @foreach ($pembelians as $pembelian)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>{{ $pembelian->nama_barang }}</span>
                                <span>Jumlah: {{ $pembelian->jumlah_barang }}</span>
                                <span>Harga Rata-Rata : Rp.
                                    {{ number_format($pembelian->harga_average, 0, ',', '.') }}</span>
                            </li>
                        @endforeach
                    </ul>
                    <h5>Gaji Pegawai</h5>
                    <ul class="list-group">
                        @foreach ($employees as $pegawai)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>Nama: {{ $pegawai->nama }}</span>
                                @if ($pegawai->gaji->isNotEmpty())
                                    <span>Gaji: Rp. {{ number_format($pegawai->gaji->first()->gaji, 0, ',', '.') }}</span>
                                @else
                                    <span>Gaji: Belum ditentukan</span>
                                @endif
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-success text-white">
                    Total Pendapatan
                </div>
                <div class="card-body">
                    <p>Rp. {{ number_format($totalPendapatan, 0, ',', '.') }}</p>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    Total Beban
                </div>
                <div class="card-body">
                    <p>Rp. {{ number_format($totalBeban, 0, ',', '.') }}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header bg-info text-white">
                    Laba Bersih
                </div>
                <div class="card-body">
                    <p>Rp. {{ number_format($labaBersih, 0, ',', '.') }}</p>
                </div>
            </div>
        </div>
    </div>
@endsection
