@extends('dashboard.layouts.main')

@section('container')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Neraca Saldo</h1>
    </div>
    <form action="{{ route('laporan.neraca-saldo') }}" method="GET" class="mb-4">
        <div class="row">
            <div class="col-md-3">
                <select name="month" class="form-control">
                    @for ($m = 1; $m <= 12; $m++)
                        <option value="{{ $m }}" {{ $m == request('month', $month) ? 'selected' : '' }}>
                            {{ DateTime::createFromFormat('!m', $m)->format('F') }}
                        </option>
                    @endfor
                </select>
            </div>
            <div class="col-md-3">
                <select name="year" class="form-control">
                    @for ($y = date('Y'); $y >= date('Y') - 2; $y--)
                        <option value="{{ $y }}" {{ $y == request('year', $year) ? 'selected' : '' }}>
                            {{ $y }}
                        </option>
                    @endfor
                </select>
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-primary">Filter</button>
            </div>
        </div>
    </form>
    <div class="row mb-3">
        <div class="col-lg-12">
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addAccountModal">
                Tambah Akun
            </button>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-default rounded-0 shadow">
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 table-responsive" style="max-height: 400px; overflow-y: auto;">
                            <table id="accountList" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>No Akun</th>
                                        <th>Tanggal</th>
                                        <th>Nama Akun</th>
                                        <th>Debit</th>
                                        <th>Kredit</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $counter = 1;
                                    @endphp

                                    @foreach ($akuns as $akun)
                                        <tr>
                                            <td>{{ $counter++ }}</td>
                                            <td>{{ $akun->created_at->format('d-m-Y') }}</td>
                                            <td>{{ $akun->nama_akun }}</td>
                                            <td>Rp.
                                                {{ $akun->tipe_akun == 'debit' ? number_format($akun->nominal, 0, ',', '.') : '0' }}
                                            </td>
                                            <td>Rp.
                                                {{ $akun->tipe_akun == 'kredit' ? number_format($akun->nominal, 0, ',', '.') : '0' }}
                                            </td>
                                        </tr>
                                    @endforeach

                                    @foreach ($history as $historys)
                                        <tr>
                                            <td>{{ $counter++ }}</td>
                                            <td>{{ $historys->created_at->format('d-m-Y') }}</td>
                                            <td>Service {{ $historys->customer->nama }}</td>
                                            <td>Rp. {{ number_format($historys->harga_total, 0, ',', '.') }}</td>
                                            <td>Rp. 0</td>
                                        </tr>
                                    @endforeach

                                    @foreach ($gaji as $gajis)
                                    <tr>
                                        <td>{{ $counter++ }}</td>
                                        <td>{{ $gajis->created_at->format('d-m-Y') }}</td>
                                        <td>Gaji {{ $gajis->employee->nama }}</td>
                                        <td>Rp. 0</td>
                                        <td>Rp. {{ number_format($gajis->gaji, 0, ',', '.') }}</td>
                                    </tr>
                                @endforeach


                                    @foreach ($pembelian as $pembelians)
                                        <tr>
                                            <td>{{ $counter++ }}</td>
                                            <td>{{ $pembelians->created_at->format('d-m-Y') }}</td>
                                            <td>Pembelian {{ $pembelians->nama_barang }}</td>
                                            <td>Rp. 0</td>
                                            <td>Rp. {{ number_format($pembelians->harga_total, 0, ',', '.') }}</td>
                                        </tr>
                                    @endforeach

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th>Total</th>
                                        <th>Rp. {{ number_format($totalDebit, 0, ',', '.') }}</th>
                                        <th>Rp. {{ number_format($totalKredit, 0, ',', '.') }}</th>
                                    </tr>
                                </tfoot>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="addAccountModal" tabindex="-1" aria-labelledby="addAccountModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addAccountModalLabel">Tambah Akun</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('neraca-saldo.store') }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label for="namaAkun" class="form-label">Nama Akun</label>
                            <input type="text" class="form-control" id="namaAkun" name="nama_akun" required>
                        </div>
                        <div class="mb-3">
                            <label for="tipeAkun" class="form-label">Tipe Akun</label>
                            <select class="form-select" id="tipeAkun" name="tipe_akun" required>
                                <option value="debit">Debit</option>
                                <option value="kredit">Kredit</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="nominalAkun" class="form-label">Nominal</label>
                            <input type="number" class="form-control" id="nominalAkun" name="nominal" required>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Tambah</button>
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
