<!-- File: resources/views/stockOpname.blade.php -->



<?php $__env->startSection('container'); ?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Stock Opname</h1>
    <a href="/stock" class="btn btn-primary">Back</a>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card card-default rounded-0 shadow">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                        <h3 class="card-title">Stock Opname</h3>
                    </div>
                    <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6 text-end">
                        <!-- You can add buttons or links here if needed -->
                    </div>
                </div>
                <div class="clear:both"></div>
            </div>
            <div class="card-body">
                <?php if($stock_opname->isEmpty()): ?>
                    <div class="alert alert-info" role="alert">
                        No stock available.
                    </div>
                <?php else: ?>
                    <form action="<?php echo e(route('stock_opname.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="row">
                            <div class="col-sm-12 table-responsive">
                                <table id="stockOpnameList" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>Id Barang</th>
                                            <th>Nama Barang</th>
                                            <th>Stock Awal</th>
                                            <th>Stock Akhir</th>
                                            <th>Selisih</th>
                                            <th>Catatan</th>
                                            <th>Tanggal Opname</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $stock_opname; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($stock->id); ?></td>
                                            <td><?php echo e($stock->nama_barang); ?></td>
                                            <td><?php echo e($stock->jumlah_barang); ?></td>
                                            <td>
                                                <input type="number" name="jumlah_akhir[<?php echo e($stock->id); ?>]" value="<?php echo e(old('jumlah_akhir.'.$stock->id, $stock->jumlah_barang)); ?>" class="form-control" data-stock-awal="<?php echo e($stock->jumlah_barang); ?>" data-id="<?php echo e($stock->id); ?>" oninput="calculateSelisih(this)">
                                            </td>
                                            <td>
                                                <input type="text" name="selisih[<?php echo e($stock->id); ?>]" value="<?php echo e(old('selisih.'.$stock->id, 0)); ?>" class="form-control selisih" data-id="<?php echo e($stock->id); ?>" readonly>
                                            </td>
                                            <td>
                                                <input type="text" name="catatan[<?php echo e($stock->id); ?>]" value="<?php echo e(old('catatan.'.$stock->id)); ?>" class="form-control">
                                            </td>
                                            <td><?php echo e(now()->toDateString()); ?></td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-sm-12 text-end">
                                <button type="submit" class="btn btn-primary">Update Stock Opname</button>
                            </div>
                        </div>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
function calculateSelisih(input) {
    const stockAwal = parseInt(input.getAttribute('data-stock-awal'));
    const stockAkhir = parseInt(input.value);
    const selisihInput = document.querySelector(`.selisih[data-id="${input.getAttribute('data-id')}"]`);

    let selisih = stockAkhir - stockAwal;
    selisihInput.value = selisih > 0 ? `+${selisih}` : selisih;
}

// Initialize selisih values on page load
document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('input[name^="jumlah_akhir"]').forEach(input => {
        calculateSelisih(input);
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Coding Skripsi\bengkel\resources\views/stockOpname.blade.php ENDPATH**/ ?>