<?php $__env->startSection('container'); ?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Customer</h1>
</div>

<form action="<?php echo e(route('customer.index')); ?>" method="GET">
    <div class="input-group mb-3">
        <input type="text" class="form-control" placeholder="Search" name="search" value="<?php echo e(request('search')); ?>">
        <button class="btn btn-danger" type="submit">Search</button>
    </div>
</form>

<div class="row">
    <div class="col-lg-12">
        <div class="card card-default rounded-0 shadow">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                        <h3 class="card-title">Customer List</h3>
                    </div>
                    <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6" align="right">
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCustomerModal">
                            <i class="far fa-plus-square"></i> Add Customer
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-12 table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Nama</th>
                                    <th>Alamat</th>
                                    <th>No Telp</th>
                                    <th>Mobil</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><b><?php echo e($customer->id); ?></b></td>
                                    <td><?php echo e($customer->nama); ?></td>
                                    <td><?php echo e($customer->alamat); ?></td>
                                    <td><?php echo e($customer->telp); ?></td>
                                    <td>
                                        <?php $__currentLoopData = $customer->mobil; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mobil): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($mobil->type); ?><?php if(!$loop->last): ?>, <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td>
                                        <a class="badge bg-warning" data-bs-toggle="modal" data-bs-target="#editCustomerModal<?php echo e($customer->id); ?>">
                                            <i class="bi bi-pencil" style="cursor: pointer;"></i>
                                        </a>
                                        <form action="<?php echo e(route('customer.destroy', $customer)); ?>" method="POST" style="display: inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button class="badge bg-danger border-0" onclick="return confirm('Are You Sure ?')">
                                                <i class="bi bi-trash3"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div id="addCustomerModal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Customer</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="container-fluid">
                    <form method="POST" action="<?php echo e(route('customer.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label class="control-label">Nama</label>
                            <input type="text" name="nama" class="form-control rounded-0" required>
                        </div>
                        <div class="mb-3">
                            <label class="control-label">No Telp</label>
                            <input type="number" name="telp" class="form-control rounded-0" required>
                        </div>
                        <div class="mb-3">
                            <label class="control-label">Alamat</label>
                            <textarea name="alamat" class="form-control rounded-0" rows="5" required></textarea>
                        </div>
                        <div id="mobilFields">
                            <div class="mb-3 d-flex">
                                <div class="flex-grow-1 me-2">
                                    <label class="control-label">Mobil</label>
                                    <input type="text" name="mobil[0][type]" class="form-control rounded-0" placeholder="Type" required>
                                </div>
                                <div class="flex-grow-1 ms-2">
                                    <label class="control-label">No Polisi</label>
                                    <input type="text" name="mobil[0][no_polisi]" class="form-control rounded-0" placeholder="No Polisi" required>
                                </div>
                            </div>
                        </div>
                        <button type="button" class="btn btn-secondary mt-2" id="addMobilField">
                            Add Mobil
                        </button>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Tambah Customer</button>
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div id="editCustomerModal<?php echo e($customer->id); ?>" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit Customer</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="container-fluid">
                    <form method="POST" action="<?php echo e(route('customer.update', $customer)); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="mb-3">
                            <label class="control-label">Nama</label>
                            <input type="text" name="nama" class="form-control rounded-0" value="<?php echo e($customer->nama); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="control-label">No Telp</label>
                            <input type="number" name="telp" class="form-control rounded-0" value="<?php echo e($customer->telp); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="control-label">Alamat</label>
                            <textarea name="alamat" class="form-control rounded-0" rows="5" required><?php echo e($customer->alamat); ?></textarea>
                        </div>
                        <div id="mobilFieldsEdit<?php echo e($customer->id); ?>">
                            <?php $__currentLoopData = $customer->mobil; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $mobil): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-3 d-flex">
                                <div class="flex-grow-1 me-2">
                                    <label class="control-label">Mobil</label>
                                    <input type="text" name="mobil[<?php echo e($index); ?>][type]" class="form-control rounded-0" value="<?php echo e($mobil->type); ?>" placeholder="Type" required>
                                </div>
                                <div class="flex-grow-1 ms-2">
                                    <label class="control-label">No Polisi</label>
                                    <input type="text" name="mobil[<?php echo e($index); ?>][no_polisi]" class="form-control rounded-0" value="<?php echo e($mobil->no_polisi); ?>" placeholder="No Polisi" required>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <button type="button" class="btn btn-secondary mt-2" id="addMobilFieldEdit<?php echo e($customer->id); ?>">
                            Add Mobil
                        </button>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Update Customer</button>
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    let mobilIndex = 1;
    document.getElementById('addMobilField').addEventListener('click', function () {
        const mobilFields = document.getElementById('mobilFields');
        const newFields = document.createElement('div');
        newFields.classList.add('mb-3', 'd-flex');
        newFields.innerHTML = `
            <div class="flex-grow-1 me-2">
                <label class="control-label">Mobil</label>
                <input type="text" name="mobil[${mobilIndex}][type]" class="form-control rounded-0" placeholder="Type">
            </div>
            <div class="flex-grow-1 ms-2">
                <label class="control-label">No Polisi</label>
                <input type="text" name="mobil[${mobilIndex}][no_polisi]" class="form-control rounded-0" placeholder="No Polisi">
            </div>
        `;
        mobilFields.appendChild(newFields);
        mobilIndex++;
    });


    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    let mobilIndexEdit<?php echo e($customer->id); ?> = <?php echo e(count($customer->mobil)); ?>;
    document.getElementById('addMobilFieldEdit<?php echo e($customer->id); ?>').addEventListener('click', function () {
        const mobilFieldsEdit = document.getElementById('mobilFieldsEdit<?php echo e($customer->id); ?>');
        const newFields = document.createElement('div');
        newFields.classList.add('mb-3', 'd-flex');
        newFields.innerHTML = `
            <div class="flex-grow-1 me-2">
                <label class="control-label">Mobil</label>
                <input type="text" name="mobil[${mobilIndexEdit<?php echo e($customer->id); ?> }][type]" class="form-control rounded-0" placeholder="Type">
            </div>
            <div class="flex-grow-1 ms-2">
                <label class="control-label">No Polisi</label>
                <input type="text" name="mobil[${mobilIndexEdit<?php echo e($customer->id); ?> }][no_polisi]" class="form-control rounded-0" placeholder="No Polisi">
            </div>
        `;
        mobilFieldsEdit.appendChild(newFields);
        mobilIndexEdit<?php echo e($customer->id); ?>++;
    });
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Files\2024\05 - Bengkel\bengkel\resources\views/customer/index.blade.php ENDPATH**/ ?>