<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\Mobil;

class CustomerController extends Controller
{
    public function index(Request $request)
    {
        $search = $request->input('search');

        $customers = Customer::with('mobil')
            ->when($search, function ($query, $search) {
                return $query->where('nama', 'like', "%{$search}%")
                             ->orWhere('alamat', 'like', "%{$search}%")
                             ->orWhere('telp', 'like', "%{$search}%")
                             ->orWhereHas('mobil', function ($query) use ($search) {
                                 $query->where('type', 'like', "%{$search}%")
                                       ->orWhere('no_polisi', 'like', "%{$search}%");
                             });
            })
            ->get();

        return view('customer.index', [
            'title' => 'Customers',
            'active' => 'customer',
            'customers' => $customers
        ]);
    }

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'nama' => 'required',
            'telp' => 'required',
            'alamat' => 'required',
        ]);

        $customer = Customer::create($validatedData);

        $this->storeMobil($request->input('mobil', []), $customer->id);

        return redirect()->route('customer.index')->with('success', 'Customer added successfully');
    }

    public function update(Request $request, Customer $customer)
    {
        $validatedData = $request->validate([
            'nama' => 'required',
            'telp' => 'required',
            'alamat' => 'required',
        ]);

        $customer->update($validatedData);

        $customer->mobil()->delete();

        $this->storeMobil($request->input('mobil', []), $customer->id);

        return redirect()->route('customer.index')->with('success', 'Customer updated successfully');
    }

    public function destroy(Customer $customer)
    {
        $customer->delete();
        return redirect()->route('customer.index')->with('success', 'Customer deleted successfully');
    }

    protected function storeMobil($mobilData, $customerId)
    {
        foreach ($mobilData as $mobil) {
            if ($mobil['type']) {
                Mobil::create([
                    'customer_id' => $customerId,
                    'type' => $mobil['type'],
                    'no_polisi' => $mobil['no_polisi']
                ]);
            }
        }
    }
}
