<?php

namespace App\Http\Controllers;

use App\Models\Employee;
use App\Models\Gaji;
use Illuminate\Http\Request;

class PenggajianController extends Controller
{
    public function index()
    {
        $employees = Employee::with('currentGaji')->get();
        return view('employee.penggajian', [
            'title' => 'Penggajian',
            'active' => 'penggajian',
            'employees' => $employees
        ]);
    }

    public function update(Request $request, Employee $employee)
    {
        $validatedData = $request->validate([
            'gaji' => 'required|numeric',
        ]);

        $employee->gaji()->create([
            'gaji' => $validatedData['gaji'],
            'effective_date' => now(),
        ]);

        return redirect()->route('penggajian.index');
    }
}
