<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Stock;
use App\Models\Stock_Opname;

class StockOpnameController extends Controller
{
    public function index()
    {
        $stock_opname = Stock_Opname::all();
        return view('stockOpname.index', [
            'title' => 'Stock Opname',
            'active' => 'stock_opname',
            'stock_opname' => $stock_opname,
        ]);
    }
    public function edit()
    {
        $stock_opname = Stock::all();
        return view('stockOpname.edit', [
            'title' => 'Stock Opname',
            'active' => 'stock_opname',
            'stock_opname' => $stock_opname,
        ]);
    }
    public function update(Request $request)
    {
        foreach ($request->jumlah_akhir as $id => $jumlah_akhir) {
            $stock = Stock::find($id);
            if ($stock) {
                $stockOpname = new Stock_Opname();
                $stockOpname->stock_id = $stock->id;
                $stockOpname->jumlah_awal = $stock->jumlah_barang;
                $stockOpname->jumlah_akhir = $jumlah_akhir;

                $selisih = $jumlah_akhir - $stock->jumlah_barang;
                $stockOpname->selisih = $selisih > 0 ? "+{$selisih}" : (string)$selisih;

                $stockOpname->catatan = $request->catatan[$id] ?? '';
                $stockOpname->save();

                // Update stock quantity in the Stock table
                $stock->jumlah_barang = $jumlah_akhir;
                $stock->save();
            }
        }

        return redirect()->route('stock_opname.index')->with('success', 'Stock Opname updated successfully');
    }
}
