<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;
use App\Models\HariLibur;

class SyncHariLibur extends Command
{
    protected $signature = 'harilibur:sync {year?}';
    protected $description = 'Sinkronisasi Hari Libur Nasional dari API';

    public function handle()
    {
        $year = $this->argument('year') ?? now()->year;
        $response = Http::get("https://api-harilibur.vercel.app/api?year={$year}");

        if ($response->successful()) {
            $data = $response->json();
            $inserted = 0;

            foreach ($data as $libur) {
                $exists = HariLibur::whereDate('tanggal', $libur['holiday_date'])->exists();
                if (!$exists) {
                    HariLibur::create([
                        'tanggal' => $libur['holiday_date'],
                        'keterangan' => $libur['holiday_name']
                    ]);
                    $inserted++;
                }
            }

            $this->info("Sinkronisasi selesai. {$inserted} hari libur baru ditambahkan.");
        } else {
            $this->error('Gagal mengambil data dari API.');
        }
    }
}
