<?php

namespace App\Exports;

use App\Models\Gaji;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class GajiExport implements FromCollection, WithHeadings
{
    public function collection()
    {
        return Gaji::with('pegawai')->get()->map(function ($gaji) {
            return [
                'Nama' => $gaji->pegawai->nama,
                'NIP' => $gaji->pegawai->nip,
                'Bulan' => $gaji->bulan,
                'Gaji Pokok' => $gaji->gaji_pokok,
                'Uang Makan' => $gaji->total_uang_makan,
                'Potongan' => $gaji->total_potongan,
                'PPh 21' => $gaji->pot_pph21,
                'Total Diterima' => $gaji->total_gaji,
            ];
        });
    }

    public function headings(): array
    {
        return ['Nama', 'NIP', 'Bulan', 'Gaji Pokok', 'Uang Makan', 'Potongan', 'PPh 21', 'Total Diterima'];
    }
}
