<?php

namespace App\Http\Controllers;

use App\Models\Pegawai;
use App\Models\Gaji;
use App\Models\Presensi;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        // Total pegawai dan status aktif
        $jumlahPegawai = Pegawai::count();
        $pegawaiAktif = Pegawai::where('status_aktif', true)->count();
        $pegawaiNonAktif = Pegawai::where('status_aktif', false)->count();

        // Bulan sekarang
        $periode = Carbon::now()->format('Y-m');

        // Total gaji pokok, uang makan, PPh 21 bulan ini
        $totalGajiPokok = Gaji::where('bulan', $periode)->sum('gaji_pokok');
        $totalUangMakan = Gaji::where('bulan', $periode)->sum('total_uang_makan');
        $totalPph21 = Gaji::where('bulan', $periode)->sum('pot_pph21');

        // Jumlah tepat waktu dan telat bulan ini
        $jumlahTepatWaktu = Presensi::where('tanggal', 'like', "$periode%")
            ->where('status', 'Hadir')->count();

        $jumlahTelat = Presensi::where('tanggal', 'like', "$periode%")
            ->where('status', 'Telat')->count();

        // Data grafik presensi bulanan (per bulan dalam 1 tahun berjalan)
        $tahunIni = date('Y');
        $presensiBulanan = Presensi::selectRaw('MONTH(tanggal) as bulan')
            ->selectRaw("SUM(CASE WHEN status = 'Hadir' THEN 1 ELSE 0 END) as hadir")
            ->selectRaw("SUM(CASE WHEN status = 'Telat' THEN 1 ELSE 0 END) as telat")
            ->whereYear('tanggal', $tahunIni)
            ->groupBy(DB::raw('MONTH(tanggal)'))
            ->orderBy('bulan')
            ->get();

        // Format ulang ke array bulan 1-12
        $grafikPresensi = [];
        for ($i = 1; $i <= 12; $i++) {
            $grafikPresensi[$i] = ['hadir' => 0, 'telat' => 0];
        }

        foreach ($presensiBulanan as $item) {
            $grafikPresensi[$item->bulan] = [
                'hadir' => $item->hadir,
                'telat' => $item->telat,
            ];
        }

        return view('dashboard', compact(
            'jumlahPegawai',
            'pegawaiAktif',
            'pegawaiNonAktif',
            'totalGajiPokok',
            'totalUangMakan',
            'totalPph21',
            'jumlahTepatWaktu',
            'jumlahTelat',
            'grafikPresensi'
        ));
    }
}
