<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Pegawai;
use App\Models\Gaji;
use Carbon\Carbon;
use DB;

class StatistikController extends Controller
{
    public function index()
    {
        // 1. Total pegawai
        $totalPegawai = Pegawai::count();

        // 2. Pegawai aktif / non-aktif
        $pegawaiAktif = Pegawai::where('status', 'aktif')->count();
        $pegawaiNonAktif = Pegawai::where('status', 'nonaktif')->count();

        // 3. Total gaji bulan ini
        $bulanSekarang = Carbon::now()->month;
        $tahunSekarang = Carbon::now()->year;

        $totalGajiBulanIni = Gaji::whereMonth('tanggal', $bulanSekarang)
            ->whereYear('tanggal', $tahunSekarang)
            ->get()
            ->sum(function ($gaji) {
                return $gaji->gaji_pokok + $gaji->total_uang_makan;
            });

        // 4. Statistik jumlah pegawai per jabatan
        $dataPerJabatan = DB::table('pegawais')
            ->join('jabatans', 'pegawais.jabatan_id', '=', 'jabatans.id')
            ->select('jabatans.nama as jabatan', DB::raw('count(*) as total'))
            ->groupBy('jabatans.nama')
            ->pluck('total', 'jabatan')
            ->toArray();

        return view('statistik.index', compact(
            'totalPegawai',
            'pegawaiAktif',
            'pegawaiNonAktif',
            'totalGajiBulanIni',
            'dataPerJabatan'
        ));
    }
}
