<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pegawai extends Model
{
    use HasFactory;

    protected $table = 'pegawais';

    protected $fillable = [
        'nama',
        'nip',
        'jabatan',
        'jabatan_id',
        'status_karyawan',
        'tanggal_masuk',
        'pendidikan_terakhir',
        'divisi',
        'gaji_pokok',
        'uang_makan_per_hari',
        'status_ptkp',
        'status_aktif',
    ];

    /**
     * Relasi ke tabel jabatan
     */
    public function jabatan()
    {
        return $this->belongsTo(Jabatan::class);
    }

    /**
     * Relasi ke tabel gaji (satu pegawai bisa punya banyak gaji)
     */
    public function gajis()
    {
        return $this->hasMany(Gaji::class);
    }

    /**
     * Relasi ke job_histories (riwayat jabatan/gaji pegawai)
     */
    public function jobHistories()
    {
        return $this->hasMany(JobHistory::class);
    }
}
