<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Jalankan migrasi: membuat tabel absensis.
     */
    public function up(): void
    {
        Schema::create('absensis', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('bulan'); // format: MMYYYY, contoh: 032025
            $table->integer('hadir')->default(0);
            $table->integer('izin')->default(0);
            $table->integer('alpha')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Kembalikan (hapus) tabel jika rollback.
     */
    public function down(): void
    {
        Schema::dropIfExists('absensis');
    }
};
