<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Jalankan migrasi: membuat tabel jabatans.
     */
    public function up(): void
    {
        Schema::create('jabatans', function (Blueprint $table) {
            $table->id();
            $table->string('nama'); // nama jabatan
            $table->bigInteger('gaji_pokok')->default(0);
            $table->bigInteger('uang_makan')->default(0);
            $table->bigInteger('transportasi')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Rollback migrasi jika dibatalkan.
     */
    public function down(): void
    {
        Schema::dropIfExists('jabatans');
    }
};
