<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Tambahkan kolom jabatan_id ke pegawais dan set foreign key
     */
    public function up(): void
    {
        Schema::table('pegawais', function (Blueprint $table) {
            $table->foreignId('jabatan_id')
                ->nullable()
                ->constrained('jabatans')
                ->onDelete('set null')
                ->after('nip');
        });
    }

    /**
     * Kembalikan perubahan (hapus kolom dan foreign key)
     */
    public function down(): void
    {
        Schema::table('pegawais', function (Blueprint $table) {
            $table->dropConstrainedForeignId('jabatan_id');
        });
    }
};
