<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Hapus kolom uang_makan dari tabel jabatans.
     */
    public function up(): void
    {
        Schema::table('jabatans', function (Blueprint $table) {
            if (Schema::hasColumn('jabatans', 'uang_makan')) {
                $table->dropColumn('uang_makan');
            }
        });
    }

    /**
     * Tambahkan kembali kolom uang_makan saat rollback.
     */
    public function down(): void
    {
        Schema::table('jabatans', function (Blueprint $table) {
            if (!Schema::hasColumn('jabatans', 'uang_makan')) {
                $table->integer('uang_makan')->default(0);
            }
        });
    }
};
