<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Jabatan;
use App\Models\Absensi;
use Illuminate\Support\Facades\Hash;

class DummyDataSeeder extends Seeder
{
    public function run(): void
    {
        // Buat Jabatan
        $jabatan = Jabatan::create([
            'nama' => 'Mandor Proyek',
            'gaji_pokok' => 5000000,
            'uang_makan' => 30000,
            'transportasi' => 20000,
        ]);

        // Buat User Pegawai
        $user = User::create([
            'name' => 'Budi Santoso',
            'email' => 'budi@example.com',
            'password' => Hash::make('password'),
            'nik' => '1234567890',
            'jabatan_id' => $jabatan->id,
        ]);

        // Buat Data Absensi untuk bulan Maret 2025
        Absensi::create([
            'user_id' => $user->id,
            'bulan' => '032025',
            'hadir' => 21,
            'izin' => 1,
            'alpha' => 1,
        ]);
    }
}

