<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Edit Gaji Pegawai') }}
        </h2>
    </x-slot>

    @php
        $maxBulan = now()->format('Y-m');
    @endphp

    <div class="py-12">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white shadow-sm sm:rounded-lg p-6">
                <form action="{{ route('gaji.update', $gaji->id) }}" method="POST">
                    @csrf
                    @method('PUT')

                    {{-- Bulan --}}
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Bulan</label>
                        <input type="month" name="bulan" id="bulan" value="{{ $gaji->bulan }}" max="{{ $maxBulan }}"
                            class="mt-1 block w-full border-gray-300 rounded-md shadow-sm" required />
                    </div>

                    {{-- Pegawai --}}
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Pegawai</label>
                        <select name="pegawai_id" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm" required>
                            @foreach ($pegawais as $p)
                                <option value="{{ $p->id }}" {{ $gaji->pegawai_id == $p->id ? 'selected' : '' }}>
                                    {{ $p->nama }} - {{ $p->nip }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Jumlah Hadir --}}
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700">Jumlah Hadir</label>
                        <input type="number" name="jumlah_hadir" id="jumlah_hadir" value="{{ $gaji->jumlah_hadir }}" min="0"
                            class="mt-1 block w-full border-gray-300 rounded-md shadow-sm" required />
                        <p id="warning-hadir" class="text-sm text-red-600 mt-1 hidden">
                            Jumlah hari pada bulan <span id="nama-bulan"></span> hanya <span id="max-hari"></span> hari.
                        </p>
                    </div>

                    {{-- Tunjangan --}}
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Tunjangan</label>
                        <div id="tunjangan-wrapper">
                            @if ($gaji->tunjangan && is_iterable($gaji->tunjangan))
                                @foreach ($gaji->tunjangan as $t)
                                    <div class="flex gap-2 mb-2">
                                        <input type="text" name="tunjangan_nama[]" value="{{ $t->nama }}" class="form-input w-1/2" placeholder="Nama Tunjangan">
                                        <input type="number" name="tunjangan_jumlah[]" value="{{ $t->jumlah }}" class="form-input w-1/2" placeholder="Jumlah">
                                    </div>
                                @endforeach
                            @endif
                            <div class="flex gap-2 mb-2">
                                <input type="text" name="tunjangan_nama[]" class="form-input w-1/2" placeholder="Nama Tunjangan">
                                <input type="number" name="tunjangan_jumlah[]" class="form-input w-1/2" placeholder="Jumlah">
                            </div>
                        </div>
                        <button type="button" onclick="tambahTunjangan()" class="text-blue-600 text-sm mt-1">+ Tambah Tunjangan</button>
                    </div>

                    {{-- Potongan Tetap --}}
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Potongan Tetap</label>

                        <div class="mb-2">
                            <label for="pot_bpjs_kesehatan">BPJS Kesehatan</label>
                            <input type="number" name="pot_bpjs_kesehatan" value="{{ $gaji->pot_bpjs_kesehatan }}" class="form-input w-full" />
                        </div>

                        <div class="mb-2">
                            <label for="pot_bpjs_ketenagakerjaan">BPJS Ketenagakerjaan</label>
                            <input type="number" name="pot_bpjs_ketenagakerjaan" value="{{ $gaji->pot_bpjs_ketenagakerjaan }}" class="form-input w-full" />
                        </div>

                        <div class="mb-2">
                            <label for="pot_pph21">PPh 21 (otomatis)</label>
                            <input type="number" name="pot_pph21" value="{{ $gaji->pot_pph21 }}" class="form-input w-full bg-gray-100 cursor-not-allowed" readonly />
                            <p class="text-sm text-gray-500 mt-1">
                                Nilai ini dihitung otomatis berdasarkan penghasilan dan status PTKP pegawai.
                            </p>
                        </div>

                        <div class="mb-2">
                            <label for="pot_absen">Potongan Absen</label>
                            <input type="number" name="pot_absen" value="{{ $gaji->pot_absen }}" class="form-input w-full" />
                        </div>

                        <div class="mb-2">
                            <label for="pot_pinjaman">Potongan Pinjaman</label>
                            <input type="number" name="pot_pinjaman" value="{{ $gaji->pot_pinjaman }}" class="form-input w-full" />
                        </div>
                    </div>

                    {{-- Potongan Lain --}}
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Potongan Lainnya</label>
                        <div id="potongan-wrapper">
                            @if ($gaji->potongan && is_iterable($gaji->potongan))
                                @foreach ($gaji->potongan as $p)
                                    <div class="flex gap-2 mb-2">
                                        <input type="text" name="potongan_nama[]" value="{{ $p->nama }}" class="form-input w-1/2" placeholder="Nama Potongan">
                                        <input type="number" name="potongan_jumlah[]" value="{{ $p->jumlah }}" class="form-input w-1/2" placeholder="Jumlah">
                                    </div>
                                @endforeach
                            @endif
                            <div class="flex gap-2 mb-2">
                                <input type="text" name="potongan_nama[]" class="form-input w-1/2" placeholder="Nama Potongan">
                                <input type="number" name="potongan_jumlah[]" class="form-input w-1/2" placeholder="Jumlah">
                            </div>
                        </div>
                        <button type="button" onclick="tambahPotongan()" class="text-red-600 text-sm mt-1">+ Tambah Potongan</button>
                    </div>

                    {{-- Submit --}}
                    <div class="flex justify-end">
                        <a href="{{ route('gaji.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded mr-2">Batal</a>
                        <button type="submit" class="bg-yellow-600 hover:bg-yellow-700 text-white px-4 py-2 rounded shadow">
                            Update Gaji
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        function tambahTunjangan() {
            const wrapper = document.getElementById('tunjangan-wrapper');
            const div = document.createElement('div');
            div.classList.add('flex', 'gap-2', 'mb-2');
            div.innerHTML = `
                <input type="text" name="tunjangan_nama[]" class="form-input w-1/2" placeholder="Nama Tunjangan">
                <input type="number" name="tunjangan_jumlah[]" class="form-input w-1/2" placeholder="Jumlah">
            `;
            wrapper.appendChild(div);
        }

        function tambahPotongan() {
            const wrapper = document.getElementById('potongan-wrapper');
            const div = document.createElement('div');
            div.classList.add('flex', 'gap-2', 'mb-2');
            div.innerHTML = `
                <input type="text" name="potongan_nama[]" class="form-input w-1/2" placeholder="Nama Potongan">
                <input type="number" name="potongan_jumlah[]" class="form-input w-1/2" placeholder="Jumlah">
            `;
            wrapper.appendChild(div);
        }

        function getMaxDaysInMonth(monthString) {
            const [year, month] = monthString.split('-');
            return new Date(year, month, 0).getDate();
        }

        const bulanInput = document.getElementById('bulan');
        const hadirInput = document.getElementById('jumlah_hadir');
        const warningText = document.getElementById('warning-hadir');
        const namaBulan = document.getElementById('nama-bulan');
        const maxHariSpan = document.getElementById('max-hari');

        function cekJumlahHari() {
            const bulan = bulanInput.value;
            const hadir = parseInt(hadirInput.value);

            if (!bulan || isNaN(hadir)) {
                warningText.classList.add('hidden');
                return;
            }

            const maxHari = getMaxDaysInMonth(bulan);
            const namaBulanText = new Date(`${bulan}-01`).toLocaleString('id-ID', { month: 'long', year: 'numeric' });

            if (hadir > maxHari) {
                warningText.classList.remove('hidden');
                namaBulan.textContent = namaBulanText;
                maxHariSpan.textContent = maxHari;
            } else {
                warningText.classList.add('hidden');
            }
        }

        bulanInput.addEventListener('change', cekJumlahHari);
        hadirInput.addEventListener('input', cekJumlahHari);
    </script>
    @endpush
</x-app-layout>
