<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold leading-tight text-gray-800">Input Uang Makan</h2>
    </x-slot>

    <div class="max-w-2xl mx-auto p-4">
        {{-- Notifikasi Error --}}
        @if ($errors->any())
            <div class="mb-4 bg-red-100 text-red-700 p-3 rounded">
                <strong>Terjadi kesalahan:</strong>
                <ul class="mt-1 list-disc list-inside text-sm">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{-- Form Input --}}
        <form action="{{ route('uangmakan.store') }}" method="POST">
            @csrf

            {{-- Input Bulan --}}
            <div class="mb-4">
                <label for="bulan" class="block font-medium">Bulan</label>
                <input type="month" name="bulan" id="bulan" class="form-input w-full"
                    value="{{ old('bulan', now()->format('Y-m')) }}" required>
                @error('bulan')
                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Pilih Pegawai --}}
            <div class="mb-4">
                <label for="pegawai_id" class="block font-medium">Pegawai</label>
                <select name="pegawai_id" id="pegawai_id" class="form-select w-full" required>
                    <option value="">-- Pilih Pegawai --</option>
                    @foreach($pegawai as $p)
                        <option value="{{ $p->id }}" {{ old('pegawai_id') == $p->id ? 'selected' : '' }}>
                            {{ $p->nama }} - {{ $p->nip }}
                        </option>
                    @endforeach
                </select>
                @error('pegawai_id')
                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Jumlah Hari Hadir --}}
            <div class="mb-4">
                <div class="flex justify-between items-center">
                    <label for="jumlah_hari" class="block font-medium">Jumlah Hari Hadir (Tanpa Telat)</label>
                    <button type="button" id="ambilPresensi" class="text-sm text-blue-600 hover:underline">
                        Ambil dari Presensi
                    </button>
                </div>
                <input type="number" name="jumlah_hari" id="jumlah_hari"
                    class="form-input w-full" min="0" value="{{ old('jumlah_hari') }}" required>
                <p class="text-sm text-gray-500 mt-1">Hanya hari hadir tanpa telat yang dihitung untuk uang makan.</p>
                @error('jumlah_hari')
                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Tarif --}}
            <div class="mb-4">
                <label for="tarif" class="block font-medium">Tarif per Hari (Rp)</label>
                <input type="number" name="tarif" id="tarif" class="form-input w-full"
                    min="0" value="{{ old('tarif', 20000) }}" required>
                @error('tarif')
                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Tombol Simpan --}}
            <div class="flex justify-end">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                    Simpan
                </button>
            </div>
        </form>
    </div>

    {{-- CSRF Token --}}
    <meta name="csrf-token" content="{{ csrf_token() }}">

    {{-- Script Ambil Presensi --}}
    <script>
        document.getElementById('ambilPresensi').addEventListener('click', function () {
            const pegawaiId = document.getElementById('pegawai_id').value;
            const bulan = document.getElementById('bulan').value;

            if (!pegawaiId || !bulan) {
                alert('Silakan pilih pegawai dan bulan terlebih dahulu.');
                return;
            }

            fetch("{{ route('presensi.hitung.hadir') }}", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": document.querySelector('meta[name=csrf-token]').getAttribute('content')
                },
                body: JSON.stringify({
                    pegawai_id: pegawaiId,
                    bulan: bulan
                }),
            })
            .then(response => response.json())
            .then(data => {
                if (data.jumlah_hadir !== undefined) {
                    document.getElementById('jumlah_hari').value = data.jumlah_hadir;
                } else {
                    alert('Gagal mengambil data presensi.');
                }
            })
            .catch(() => alert('Terjadi kesalahan saat mengambil data.'));
        });
    </script>
</x-app-layout>
