<x-app-layout>
    <div class="max-w-2xl mx-auto p-4">
        <h2 class="text-xl font-bold mb-4">Edit Uang Makan</h2>

        {{-- Notifikasi Error --}}
        @if ($errors->any())
            <div class="mb-4 bg-red-100 text-red-700 p-3 rounded">
                <strong>Terjadi kesalahan:</strong>
                <ul class="mt-1 list-disc list-inside text-sm">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{-- Form --}}
        <form action="{{ route('uangmakan.update', $uangmakan->id) }}" method="POST">
            @csrf
            @method('PUT')

            {{-- Bulan --}}
            <div class="mb-4">
                <label for="bulan" class="block font-medium">Bulan</label>
                <input type="month" name="bulan" id="bulan"
                    class="form-input w-full"
                    value="{{ old('bulan', $uangmakan->bulan) }}"
                    required>
                @error('bulan')
                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Pegawai --}}
            <div class="mb-4">
                <label for="pegawai_id" class="block font-medium">Pegawai</label>
                <select name="pegawai_id" id="pegawai_id"
                    class="form-select w-full"
                    required>
                    @foreach ($pegawai as $p)
                        <option value="{{ $p->id }}" {{ old('pegawai_id', $uangmakan->pegawai_id) == $p->id ? 'selected' : '' }}>
                            {{ $p->nama }} - {{ $p->nip }}
                        </option>
                    @endforeach
                </select>
                @error('pegawai_id')
                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Jumlah Hadir --}}
            <div class="mb-4">
                <label for="jumlah_hari" class="block font-medium">Jumlah Hari Hadir (Tanpa Telat)</label>
                <input type="number" name="jumlah_hari" id="jumlah_hari"
                    class="form-input w-full" min="0"
                    value="{{ old('jumlah_hari', $uangmakan->jumlah_hari) }}"
                    required>
                <p class="text-sm text-gray-500 mt-1">Hanya hari hadir tanpa keterlambatan yang dihitung.</p>
                @error('jumlah_hari')
                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Tarif --}}
            <div class="mb-4">
                <label for="tarif" class="block font-medium">Tarif per Hari (Rp)</label>
                <input type="number" name="tarif" id="tarif"
                    class="form-input w-full" min="0"
                    value="{{ old('tarif', $uangmakan->tarif) }}"
                    required>
                @error('tarif')
                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Tombol --}}
            <div class="flex justify-end">
                <button type="submit"
                    class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                    Update
                </button>
            </div>
        </form>
    </div>
</x-app-layout>
