<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Laporan Uang Makan
            @if(isset($periode))
                – {{ \Carbon\Carbon::parse($periode)->translatedFormat('F Y') }}
            @endif
        </h2>
    </x-slot>

    <div class="py-6 px-6">

        {{-- Filter Periode --}}
        <form action="{{ route('uangmakan.laporan') }}" method="GET" class="flex items-center gap-3 mb-4">
            <select name="periode" class="border rounded px-3 py-2">
                @foreach($semuaPeriode as $p)
                    <option value="{{ $p }}" {{ request('periode') == $p ? 'selected' : '' }}>
                        {{ \Carbon\Carbon::parse($p . '-01')->translatedFormat('F Y') }}
                    </option>
                @endforeach
            </select>
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                Tampilkan
            </button>

            @if(isset($periode))
                <a href="{{ route('uangmakan.cetak', ['bulan' => \Carbon\Carbon::parse($periode)->format('m'), 'tahun' => \Carbon\Carbon::parse($periode)->format('Y')]) }}"
                   target="_blank"
                   class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700">
                    Cetak PDF
                </a>
            @endif
        </form>

        {{-- Tabel Data --}}
        @if(isset($uangmakan) && $uangmakan->count())
            <div class="bg-white rounded shadow overflow-x-auto">
                <table class="w-full text-sm border border-gray-200">
                    <thead class="bg-gray-100 text-left">
                        <tr>
                            <th class="border px-3 py-2">#</th>
                            <th class="border px-3 py-2">Nama Pegawai</th>
                            <th class="border px-3 py-2">Bulan</th>
                            <th class="border px-3 py-2 text-center">Hadir</th>
                            <th class="border px-3 py-2 text-right">Uang Makan / Hari</th>
                            <th class="border px-3 py-2 text-right">Total Uang Makan</th>
                            <th class="border px-3 py-2 text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($uangmakan as $i => $item)
                            <tr class="hover:bg-gray-50">
                                <td class="border px-3 py-2">{{ $i + 1 }}</td>
                                <td class="border px-3 py-2">{{ $item->pegawai->nama }}</td>
                                <td class="border px-3 py-2">{{ $item->bulan }}</td>
                                <td class="border px-3 py-2 text-center">{{ $item->jumlah_hari }}</td>
                                <td class="border px-3 py-2 text-right">
                                    Rp {{ number_format($item->tarif, 0, ',', '.') }}
                                </td>
                                <td class="border px-3 py-2 text-right font-semibold text-green-600">
                                    Rp {{ number_format($item->jumlah, 0, ',', '.') }}
                                </td>
                                <td class="border px-3 py-2 text-center">
                                    <a href="{{ route('uangmakan.edit', $item->id) }}"
                                       class="bg-yellow-400 text-white px-3 py-1 rounded hover:bg-yellow-500 text-sm">
                                        Edit
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @elseif(isset($periode))
            <div class="text-gray-500 mt-4">Data tidak ditemukan untuk periode tersebut.</div>
        @endif

    </div>
</x-app-layout>
