
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Uang Makan</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #000; padding: 6px; text-align: left; }
        th { background: #f0f0f0; }
        tfoot td { font-weight: bold; background: #f9f9f9; }
    </style>
</head>
<body>
    <h2>Laporan Uang Makan – {{ \Carbon\Carbon::parse($periode)->translatedFormat('F Y') }}</h2>

    <table>
        <thead>
            <tr>
                <th>Nama</th>
                <th>NIP</th>
                <th>Jabatan</th>
                <th>Hadir</th>
                <th>Uang Makan / Hari</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            @php $grandTotal = 0; @endphp
            @foreach ($uangmakan as $item)
                <tr>
                    <td>{{ $item->pegawai->nama ?? '-' }}</td>
                    <td>{{ $item->pegawai->nip ?? '' }}</td>
                    <td>{{ $item->pegawai->jabatan->nama ?? '-' }}</td>
                    <td style="text-align: center;">{{ $item->jumlah_hari }}</td>
                    <td style="text-align: right;">Rp {{ number_format($item->tarif, 0, ',', '.') }}</td>
                    <td style="text-align: right;">Rp {{ number_format($item->jumlah, 0, ',', '.') }}</td>
                </tr>
                @php $grandTotal += $item->jumlah; @endphp
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td colspan="5" style="text-align: right;">Total Uang Makan Bulan Ini</td>
                <td style="text-align: right;">Rp {{ number_format($grandTotal, 0, ',', '.') }}</td>
            </tr>
        </tfoot>
    </table>
</body>
</html>
