<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-gray-800 leading-tight">
            Import Data Pegawai
        </h2>
    </x-slot>

    <div class="py-6 px-4 max-w-3xl mx-auto">

        {{-- Flash Success --}}
        @if (session('success'))
            <div class="bg-green-100 text-green-800 border border-green-300 px-4 py-3 rounded mb-4">
                {{ session('success') }}
            </div>
        @endif

        {{-- Flash Error Umum --}}
        @if (session('error'))
            <div class="bg-red-100 text-red-800 border border-red-300 px-4 py-3 rounded mb-4">
                {!! session('error') !!}
            </div>
        @endif

        {{-- Flash Error Detail dari PegawaiImport --}}
        @if (session('import_errors'))
            <div class="bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded mb-4">
                <strong class="block mb-1">Beberapa data gagal diimpor:</strong>
                <ul class="list-disc list-inside text-sm">
                    @foreach (session('import_errors') as $error)
                        <li>
                            @if(is_array($error))
                                Baris ke-{{ $error['baris'] ?? '?' }}: {{ $error['pesan'] ?? 'Kesalahan tidak diketahui' }}
                            @else
                                {!! $error !!}
                            @endif
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{-- Form Upload --}}
        <form action="{{ route('pegawai.import') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700">Upload File Excel (.xlsx / .csv)</label>
                <input type="file" name="file" accept=".xls,.xlsx,.csv" required
                    class="mt-2 block w-full border border-gray-300 rounded p-2 focus:ring focus:ring-blue-200">
                @error('file')
                    <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                @enderror
            </div>

            <x-primary-button>📤 Import</x-primary-button>
        </form>

        {{-- Link download template --}}
        <p class="mt-6 text-sm">
            Belum punya template? 
            <a href="{{ asset('template/template-import-pegawai.xlsx') }}" class="text-blue-600 underline hover:text-blue-800">
                📥 Download Template Excel
            </a>
        </p>
    </div>
</x-app-layout>
