<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Daftar Pegawai
        </h2>
    </x-slot>

    <div class="py-6 px-8">

        {{-- Flash Message: Sukses --}}
        @if (session('success'))
            <div class="mb-4 p-4 bg-green-100 text-green-800 rounded">
                {{ session('success') }}
            </div>
        @endif

        {{-- Flash Message: Error Import --}}
        @if (Session::has('import_errors'))
            <div class="mb-4 p-4 bg-yellow-100 text-yellow-800 rounded">
                <strong>Beberapa baris gagal diimport:</strong>
                <ul class="list-disc list-inside mt-1">
                    @foreach (Session::get('import_errors') as $err)
                        <li>Baris {{ $err['baris'] }}: {{ $err['pesan'] }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{-- Pencarian --}}
        <form action="{{ route('pegawai.index') }}" method="GET" class="mb-4">
            <div class="flex gap-2">
                <input type="text" name="search" placeholder="Cari nama atau NIP..."
                    value="{{ request('search') }}"
                    class="border rounded px-4 py-2 w-full" />
                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded">Cari</button>
            </div>
        </form>

        {{-- Form Hapus Terpilih --}}
        <form action="{{ route('pegawai.bulkDelete') }}" method="POST" onsubmit="return confirm('Yakin ingin menghapus data yang dipilih?')">
            @csrf
            @method('DELETE')

            <div class="flex justify-between items-center mb-3">
                <a href="{{ route('pegawai.create') }}"
                    class="bg-blue-600 text-white px-4 py-2 rounded">+ Tambah Pegawai</a>
                <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700">
                    Hapus Terpilih
                </button>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full table-auto border border-gray-300 text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="border px-3 py-2 text-center">
                                <input type="checkbox" id="select-all">
                            </th>
                            <th class="border px-3 py-2 text-left">Nama</th>
                            <th class="border px-3 py-2 text-left">NIP</th>
                            <th class="border px-3 py-2 text-left">Jabatan</th>
                            <th class="border px-3 py-2 text-left">Divisi</th>
                            <th class="border px-3 py-2 text-left">Status Karyawan</th>
                            <th class="border px-3 py-2 text-left">Status Aktif</th>
                            <th class="border px-3 py-2 text-left">Tanggal Masuk</th>
                            <th class="border px-3 py-2 text-left">Pendidikan</th>
                            <th class="border px-3 py-2 text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @forelse ($pegawais as $pegawai)
                            <tr class="{{ !$pegawai->status_aktif ? 'bg-red-50' : '' }}">
                                <td class="border px-3 py-2 text-center">
                                    <input type="checkbox" name="ids[]" value="{{ $pegawai->id }}" class="checkbox-item">
                                </td>
                                <td class="border px-3 py-2 text-gray-800">{{ $pegawai->nama }}</td>
                                <td class="border px-3 py-2 text-gray-800">{{ $pegawai->nip }}</td>
                                <td class="border px-3 py-2 text-gray-800">{{ $pegawai->jabatan->nama ?? '-' }}</td>
                                <td class="border px-3 py-2 text-gray-800">{{ $pegawai->divisi ?? '-' }}</td>
                                <td class="border px-3 py-2 text-gray-800">{{ $pegawai->status_karyawan ?? '-' }}</td>
                                <td class="border px-3 py-2">
                                    <span class="inline-block px-2 py-1 text-xs rounded-full font-semibold
                                        {{ $pegawai->status_aktif ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-700' }}">
                                        {{ $pegawai->status_aktif ? 'Aktif' : 'Resign' }}
                                    </span>
                                </td>
                                <td class="border px-3 py-2 text-gray-800">
                                    {{ $pegawai->tanggal_masuk ? \Carbon\Carbon::parse($pegawai->tanggal_masuk)->format('d/m/Y') : '-' }}
                                </td>
                                <td class="border px-3 py-2 text-gray-800">{{ $pegawai->pendidikan_terakhir ?? '-' }}</td>
                                <td class="border px-3 py-2 text-center">
                                    <a href="{{ route('pegawai.show', $pegawai->id) }}"
                                        class="text-blue-600 hover:underline">Detail</a> |
                                    <a href="{{ route('pegawai.edit', $pegawai->id) }}"
                                        class="text-green-600 hover:underline">Edit</a> |
                                    <form action="{{ route('pegawai.destroy', $pegawai->id) }}" method="POST"
                                        class="inline" onsubmit="return confirm('Yakin ingin menghapus data ini?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-red-600 hover:underline">Hapus</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="10" class="px-4 py-2 text-center text-gray-500">Tidak ada data pegawai.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </form>

        <div class="mt-4">
            {{ $pegawais->links() }}
        </div>
    </div>

    @push('scripts')
    <script>
        document.getElementById('select-all').addEventListener('change', function () {
            const checkboxes = document.querySelectorAll('.checkbox-item');
            checkboxes.forEach(cb => cb.checked = this.checked);
        });
    </script>
    @endpush
</x-app-layout>
