<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Slip Penghasilan Tahunan - <?php echo e($pegawai->nama); ?></title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { border-collapse: collapse; width: 100%; margin-bottom: 20px; }
        th, td { border: 1px solid #000; padding: 6px; }
        th { background-color: #f0f0f0; }
        h2, h3 { margin-bottom: 10px; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .text-red-600 { color: red; }
        .text-green-600 { color: green; }
    </style>
</head>
<body>

    <h2 class="text-center">Slip Penghasilan Tahunan</h2>
    <h3>Nama: <?php echo e($pegawai->nama); ?></h3>
    <p>
        NIP: <?php echo e($pegawai->nip); ?><br>
        Divisi: <?php echo e($pegawai->divisi); ?><br>
        Status PTKP: <?php echo e($pegawai->status_ptkp); ?><br>
        Tahun: <?php echo e($tahun); ?>

    </p>

    <h3>Rincian Penghasilan</h3>
    <table>
        <thead>
            <tr>
                <th>Bulan</th>
                <th class="text-right">Gaji Pokok</th>
                <th class="text-right">Uang Makan</th>
                <th class="text-right">Tunjangan</th>
                <th class="text-right">Potongan</th>
                <th class="text-right">Gaji Bersih</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $gajis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gaji): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $tunjangan = is_iterable($gaji->tunjangan) ? collect($gaji->tunjangan)->sum('jumlah') : 0;
                    $potonganTambahan = is_iterable($gaji->potongan) ? collect($gaji->potongan)->sum('jumlah') : 0;
                    $potongan = $potonganTambahan
                        + ($gaji->pot_bpjs_kesehatan ?? 0)
                        + ($gaji->pot_bpjs_jht ?? 0)
                        + ($gaji->pot_bpjs_jpens ?? 0)
                        + ($gaji->pot_pph21 ?? 0)
                        + ($gaji->pot_absen ?? 0)
                        + ($gaji->pot_pinjaman ?? 0);
                    $gajiBersih = ($gaji->gaji_pokok ?? 0) + ($gaji->total_uang_makan ?? 0) + $tunjangan - $potongan;
                ?>
                <tr>
                    <td><?php echo e(\Carbon\Carbon::createFromFormat('Y-m', $gaji->bulan)->translatedFormat('F Y')); ?></td>
                    <td class="text-right">Rp <?php echo e(number_format($gaji->gaji_pokok, 0, ',', '.')); ?></td>
                    <td class="text-right">Rp <?php echo e(number_format($gaji->total_uang_makan, 0, ',', '.')); ?></td>
                    <td class="text-right">Rp <?php echo e(number_format($tunjangan, 0, ',', '.')); ?></td>
                    <td class="text-right">Rp <?php echo e(number_format($potongan, 0, ',', '.')); ?></td>
                    <td class="text-right">Rp <?php echo e(number_format($gajiBersih, 0, ',', '.')); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <th>Total</th>
                <th class="text-right">Rp <?php echo e(number_format($totalGaji ?? 0, 0, ',', '.')); ?></th>
                <th class="text-right">Rp <?php echo e(number_format($totalUangMakan ?? 0, 0, ',', '.')); ?></th>
                <th class="text-right">Rp <?php echo e(number_format($totalTunjangan ?? 0, 0, ',', '.')); ?></th>
                <th class="text-right">Rp <?php echo e(number_format($totalPotongan ?? 0, 0, ',', '.')); ?></th>
                <th class="text-right">Rp <?php echo e(number_format($totalGajiBersih ?? 0, 0, ',', '.')); ?></th>
            </tr>
        </tfoot>
    </table>

    <h3>Rekonsiliasi PPh 21 Tahunan</h3>
    <table>
        <tr><th>Penghasilan Kotor</th><td class="text-right">Rp <?php echo e(number_format($rekap['penghasilan_kotor'], 0, ',', '.')); ?></td></tr>
        <tr><th>Biaya Jabatan (5% max 6jt)</th><td class="text-right">Rp <?php echo e(number_format($rekap['penghasilan_kotor'] * 0.05 > 6000000 ? 6000000 : $rekap['penghasilan_kotor'] * 0.05, 0, ',', '.')); ?></td></tr>
        <tr><th>Penghasilan Neto</th><td class="text-right">Rp <?php echo e(number_format($rekap['penghasilan_neto'], 0, ',', '.')); ?></td></tr>
        <tr><th>PTKP</th><td class="text-right">Rp <?php echo e(number_format($rekap['ptkp'], 0, ',', '.')); ?></td></tr>
        <tr><th>PKP</th><td class="text-right">Rp <?php echo e(number_format($rekap['pkp'], 0, ',', '.')); ?></td></tr>
        <tr><th>PPH 21 Aktual (Progresif)</th><td class="text-right">Rp <?php echo e(number_format($rekap['pph_aktual'], 0, ',', '.')); ?></td></tr>
        <tr><th>PPH Terpotong</th><td class="text-right">Rp <?php echo e(number_format($rekap['pph_terpotong'], 0, ',', '.')); ?></td></tr>
        <tr>
            <th>Selisih</th>
            <td class="text-right">
                <strong class="<?php echo e($rekap['selisih'] < 0 ? 'text-red-600' : 'text-green-600'); ?>">
                    Rp <?php echo e(number_format($rekap['selisih'], 0, ',', '.')); ?>

                </strong>
            </td>
        </tr>
    </table>

    <p><strong>Catatan:</strong><br>
        <em>Penghasilan Neto</em> berbeda dengan <em>Gaji Bersih</em> karena <strong>biaya jabatan</strong> dan <strong>iuran pensiun (1% dari gaji pokok per bulan × 12)</strong> harus dikurangkan dari Penghasilan Kotor untuk menghitung kewajiban pajak (PKP). Hal ini sesuai peraturan perpajakan yang berlaku untuk menghitung PPh 21 tahunan.</p>

</body>
</html>
<?php /**PATH D:\xampp\htdocs\penggajian-app\resources\views/gaji/slip_total.blade.php ENDPATH**/ ?>