<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Data Gaji – <?php echo e(\Carbon\Carbon::parse($periode)->translatedFormat('F Y')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-6 px-4 sm:px-6 lg:px-8">
        <div class="mb-4 flex justify-between">
            <div class="flex space-x-2">
                <a href="<?php echo e(route('gaji.create')); ?>"
                   class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded text-sm">
                    + Tambah Data Gaji
                </a>
                <a href="<?php echo e(route('gaji.import')); ?>"
                   class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded text-sm">
                    📥 Import Excel
                </a>
            </div>
        </div>

        <div class="mb-6">
            <form action="<?php echo e(route('gaji.index')); ?>" method="GET" class="flex flex-col sm:flex-row sm:items-center gap-2">
                <select name="periode" class="border rounded px-4 py-2 text-sm">
                    <?php $__currentLoopData = $semuaPeriode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($item); ?>" <?php echo e($item == $periode ? 'selected' : ''); ?>>
                            <?php echo e(\Carbon\Carbon::parse($item)->translatedFormat('F Y')); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <button type="submit" class="bg-gray-700 text-white px-3 py-2 rounded text-sm hover:bg-gray-800">
                    Filter
                </button>
            </form>
        </div>

        <div class="bg-white shadow rounded-lg overflow-x-auto">
            <table class="w-full table-auto border text-sm">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-4 py-2 border text-left">#</th>
                        <th class="px-4 py-2 border text-left">Nama Pegawai</th>
                        <th class="px-4 py-2 border text-left">Bulan</th>
                        <th class="px-4 py-2 border text-left">Hadir</th>
                        <th class="px-4 py-2 border text-left">Uang Makan</th>
                        <th class="px-4 py-2 border text-left">Total Gaji</th>
                        <th class="px-4 py-2 border text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $gajis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $gaji): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-2 border"><?php echo e($index + 1); ?></td>
                            <td class="px-4 py-2 border"><?php echo e($gaji->pegawai->nama); ?></td>
                            <td class="px-4 py-2 border"><?php echo e($gaji->bulan); ?></td>
                            <td class="px-4 py-2 border"><?php echo e($gaji->jumlah_hadir); ?></td>
                            <td class="px-4 py-2 border">Rp <?php echo e(number_format($gaji->total_uang_makan, 0, ',', '.')); ?></td>
                            <td class="px-4 py-2 border">Rp <?php echo e(number_format($gaji->total_gaji, 0, ',', '.')); ?></td>
                            <td class="px-4 py-2 border text-center">
                                <div class="flex flex-wrap justify-center gap-1">
                                    <a href="<?php echo e(route('gaji.show', $gaji->id)); ?>"
                                       class="bg-blue-500 text-white px-2 py-1 rounded text-xs">Detail</a>
                                    <a href="<?php echo e(route('gaji.edit', $gaji->id)); ?>"
                                       class="bg-yellow-500 text-white px-2 py-1 rounded text-xs">Edit</a>
                                    <form action="<?php echo e(route('gaji.destroy', $gaji->id)); ?>" method="POST"
                                          onsubmit="return confirm('Yakin ingin menghapus?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit"
                                                class="bg-red-600 text-white px-2 py-1 rounded text-xs">Hapus</button>
                                    </form>
                                    <a href="<?php echo e(route('gaji.slip', $gaji->id)); ?>"
                                       class="bg-green-600 text-white px-2 py-1 rounded text-xs" target="_blank">
                                        Slip PDF
                                    </a>
                                    <a href="<?php echo e(route('gaji.slip_total', $gaji->pegawai_id)); ?>"
                                       class="bg-gray-700 text-white px-2 py-1 rounded text-xs" target="_blank">
                                        Slip Tahunan
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center py-4 text-gray-500">
                                Tidak ada data gaji untuk periode ini.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<?php /**PATH D:\xampp\htdocs\penggajian-app\resources\views/gaji/index.blade.php ENDPATH**/ ?>