@extends('dashboard.layouts.main')
@section('container')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">History</h1>
    </div>
    <form action="{{ route('history.index') }}" method="GET">
    <div class="input-group mb-3">
        <input type="text" class="form-control" placeholder="Search" name="search" value="{{ request('search') }}">
        <input type="date" class="form-control" name="start_date" value="{{ request('start_date') }}">
        <input type="date" class="form-control" name="end_date" value="{{ request('end_date') }}">
        <button class="btn btn-danger" type="submit">Search</button>
    </div>
</form>

    <div class="row">
        <div class="col-lg-12">
            <div class="card card-default rounded-0 shadow">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                            <h3 class="card-title">History</h3>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6 text-end">
                        </div>
                    </div>
                    <div class="clear:both"></div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 table-responsive">
                            <table id="supplierList" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama Customer</th>
                                        <th>No Polisi</th>
                                        <th>Nama Employee</th>
                                        <th>Discount</th>
                                        <th>Total Harga</th>
                                        <th>Tanggal</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $no = 1;
                                    @endphp
                                    @foreach ($history as $data)
                                    <tr>
                                        <td>{{ $no++ }}</td>
                                        <td>
                                            <a href="#modal{{ $data->id }}" data-bs-toggle="modal">{{ $data->nama }}</a>
                                        </td>
                                        <td>{{ $data->no_polisi }}</td>
                                        <td>{{ $data->nama_pegawai }}</td>
                                        <td>{{ $data->discount }}%</td>
                                        <td>Rp. {{ number_format($data->harga_total) }}</td>
                                        <td>{{ \Carbon\Carbon::parse($data->created_at)->format('d-m-Y') }}</td>
                                        <td>
                                            <a href="{{ route('history.print', $data->id) }}" target="_BLANK" class="badge bg-success"><i class="bi bi-printer" style="cursor: pointer;"></i></a>
                                            <a href="{{ route('service', $data->id) }}" class="badge bg-warning"><i class="bi bi-pencil" style="cursor: pointer;"></i></a>
                                            <form action="{{ route('deleteHistory', $data->id) }}" method="post" style="display: inline-block;">
                                                @csrf
                                                @method('DELETE')
                                                <button class="badge bg-danger border-0" onclick="return confirm('Are You Sure ?')"><i class="bi bi-trash3"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>

                            @foreach ($history as $data)
                            <!-- Modal -->
                            <div class="modal fade" id="modal{{ $data->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" >
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">{{ $data->nama }}</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <p><strong>No Polisi:</strong> {{ $data->no_polisi }}</p>
                                            <p><strong>Pegawai:</strong> {{ $data->nama_pegawai }}</p>
                                            <p><strong>Detail Service:</strong></p>
                                            <div class="table-responsive">
                                                <table class="table table-bordered table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>No</th>
                                                            <th>Nama Barang/Jasa</th>
                                                            <th>Jumlah</th>
                                                            <th>Satuan</th>
                                                            <th>Harga</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @php
                                                            $serviceNo = 1;
                                                        @endphp
                                                        @foreach ($data->services as $service)
                                                        <tr>
                                                            <td>{{ $serviceNo++ }}</td>
                                                            <td>{{ optional($service->stock)->nama_barang }} {{ $service->jasa }}</td>
                                                            <td>{{ $service->jumlah }}</td>
                                                            <td>{{ $service->satuan }}</td>
                                                            <td>Rp. {{ number_format($service->total_harga) }}</td>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                            <p><strong>Discount:</strong> {{ $data->discount }}%</p>
                                            <p><strong>Total Harga:</strong> Rp. {{ number_format($data->harga_total) }}</p>
                                            <p><strong>Tanggal:</strong> {{ \Carbon\Carbon::parse($data->created_at)->format('d-m-Y') }}</p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
