<?php $__env->startSection('container'); ?>
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Customer</h1>
    </div>
    <div class="input-group mb-3">
        <input type="text" class="form-control" placeholder="Search" name="search" value="<?php echo e(request('search')); ?>">
        <button class="btn btn-danger" type="submit">Search</button>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-default rounded-0 shadow">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                            <h3 class="card-title">Customer List</h3>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6" align="right">
                            <button type="button" id="addCustomer" class="btn btn-primary" data-bs-toggle="modal"
                                data-bs-target="#addCustomerModal" class="btn btn-primary bg-gradient btn-sm rounded-1"><i
                                    class="far fa-plus-square"></i> Add Customer</button>
                        </div>
                    </div>
                    <div class="clear:both"></div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 table-responsive">
                            <table id="customerList" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Nama</th>
                                        <th>Alamat</th>
                                        <th>No Telp</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                    </tr>
                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($customer->id); ?></td>
                                        <td><?php echo e($customer->nama); ?></td>
                                        <td><?php echo e($customer->alamat); ?></td>
                                        <td><?php echo e($customer->telp); ?></td>
                                        <td>
                                            
                                            <form action="<?php echo e(route('customer.destroy', $customer)); ?>" method="post" style="display: inline-block;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button
                                                class="badge bg-danger border-0"
                                                onclick="return confirm('Are You Sure ?')"><i
                                                    class="bi bi-trash3"></i></button></td>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div id="addCustomerModal" class="modal fade">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Add Customer</h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="container-fluid">
                            <form method="post" action="<?php echo e(route('customer.store')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="mb-3">
                                    <label class="control-label">Nama</label>
                                    <input type="text" name="nama" class="form-control rounded-0" required>
                                </div>
                                <div class="mb-3">
                                    <label class="control-label">No Telp</label>
                                    <input type="number" name="telp" class="form-control rounded-0" required>
                                </div>
                                <div class="mb-3">
                                    <label class="control-label">Alamat</label>
                                    <textarea name="alamat" class="form-control rounded-0" rows="5" required></textarea>
                                </div>
                                <div class="modal-footer">
                                    <button type="submit" class="btn btn-success">Tambah Customer</button>
                                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Coding Skripsi\bengkel\resources\views/customer.blade.php ENDPATH**/ ?>