<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Employee;
class EmployeeController extends Controller
{
    public function index()
    {
        $employees = Employee::all();
        return view('employee.index', [
            'title' => 'Login',
            'active' => 'login',
            'employees' => $employees
        ]);
    }

    // Store a newly created employee
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'nama' => 'required|max:255',
            'alamat' => 'required',
            'telp' => 'required|max_digits:15',
        ]);

        Employee::create($validatedData);
        return redirect()->route('employees.index');
    }
    // Update the specified employee
    public function update(Request $request, Employee $employee)
{
    $validatedData = $request->validate([
        'nama' => 'required|max:255',
        'telp' => 'required|max_digits:15',
        'alamat' => 'required',
    ]);

    $employee->update($validatedData);
    return redirect()->route('employees.index');
}

    // Remove the specified employee
    public function destroy(Employee $employee)
    {
        $employee->delete();
        return redirect()->route('employees.index');
    }
}
