@extends('dashboard.layouts.main')
@section('container')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Service</h1>
    </div>

    <div class="row">

        <div class="col-lg-3">
            <form action="{{ route('cekNota') }}" method="POST">
                @csrf
                <label for="nopol" class="form-label">Nomor Nota</label>
                <div class="input-group">
                    <input type="text" class="form-control" name="nota">
                    <button class="btn btn-outline-secondary" type="submit">
                        <i class="bi bi-search"></i>
                    </button>
                </div>
            </form>
        </div>
        {{-- Form Nama --}}
        <div class="col-lg-3"> <!-- Adjust the column width as needed -->
            <form method="post" action="/service" class="mb-3">
                <label for="nama" class="form-label">Nama</label>
                <input type="text" class="form-control"
                    @if ($customers) value="{{ $customers->nama }}" @endif id="notelp" name="notelp"
                    disabled>
        </div>

        {{-- form no telp --}}
        <div class="col-lg-3"> <!-- Adjust the column width as needed -->
            <div class="mb-">
                <label for="notelp" class="form-label">No Telpon</label>
                <input type="text" class="form-control"
                    @if ($customers) value="{{ $customers->telp }}" @endif id="notelp" name="notelp"
                    disabled>

            </div>
        </div>


        {{-- jenis mobil --}}
        <div class="col-lg-3"> <!-- Adjust the column width as needed -->
            <label for="jenis" class="form-label">Jenis Mobil</label>
            <input type="text" class="form-control"
                @if ($customers) value="{{ $customers->type }}" @endif id="notelp" name="notelp"
                disabled>
        </div>
    </div>


    <div class="row">
        {{-- form nopol --}}
        <div class="col-lg-3">
            <form action="{{ route('cek') }}" method="POST">
                @csrf
                <label for="nopol" class="form-label">No Polisi</label>
                <div class="input-group">
                    <input type="text" class="form-control @error('nopol') is-invalid @enderror" id="nopol"
                        @if ($customers) value="{{ $customers->no_polisi }}" @endif name="nopol" required
                        value="{{ old('nopol') }}">
                    <button class="btn btn-outline-secondary" type="submit">
                        <i class="bi bi-search"></i> <!-- Magnifying glass icon -->
                    </button>
                </div>
                @error('nopol')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror
            </form>
        </div>

        {{-- form kilometer --}}
        <div class="col-lg-3">
            <form action="{{ route('tambahHistory') }}" method="POST">
                @csrf
            <label for="kilometer" class="form-label">Kilometer</label>
            <input type="text" class="form-control  @error('kilometer') is-invalid @enderror" id="kilometer"
                name="kilometer" required value="{{ old('kilometer') }}">
            @error('kilometer')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
            @enderror
        </div>
        {{-- form pegawai yang melakukan service --}}
        <div class="col-lg-3 mb-3">
            <label for="pegawai" class="form-label">Pegawai</label>
            <select class="form-select" name="employee_id" required>
                <option value="">-Pilih Pegawai-</option>
                @foreach ($pegawai as $data)
                    <option value="{{ $data->id }}">{{ $data->nama }}</option>
                @endforeach
            </select>
        </div>

        {{-- form waktu service --}}

    </div>
    <div class="row mb-3">
        <div class="col-lg-3">
            <input type="hidden" name="customer_id" @if ($customers) value="{{ $customers->customer_id }}" @endif  id="">
            <input type="hidden" name="no_polisi" @if ($customers) value="{{ $customers->no_polisi }}" @endif  id="">
            <input type="hidden" name="jenis_mobil" @if ($customers) value="{{ $customers->type }}" @endif  id="">
            <button class="btn btn-primary">Simpan</button>
        </form>
        </div>
    </div>

@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        function calculateTotalHarga() {
            var hargaBarang = parseFloat($('#harga_barang').val());
            var jumlah = parseInt($('#jumlah').val());
            if (!isNaN(hargaBarang) && !isNaN(jumlah)) {
                var totalHarga = hargaBarang * jumlah;
                $('#total_harga').val(totalHarga);
                calculateHargaAkhir(); // Panggil fungsi untuk menghitung harga akhir
            } else {
                $('#total_harga').val('');
            }
        }

        function calculateHargaAkhir() {
            var totalHarga = parseFloat($('#total_harga').val());
            var discount = parseFloat($('#discount').val());
            if (!isNaN(totalHarga) && !isNaN(discount)) {
                var hargaAkhir = totalHarga - (totalHarga * (discount / 100));
                $('#harga_akhir').val(hargaAkhir); // Format ke dua angka di belakang koma
            } else {
                $('#harga_akhir').val('');
            }
        }

        $('#stock_id').change(function() {
            var stockId = $(this).val();
            if (stockId) {
                $.ajax({
                    url: '/get-stock/' + stockId,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        if (data.harga_barang !== null) {
                            $('#harga_barang').val(data.harga_barang);
                            calculateTotalHarga();
                        } else {
                            $('#harga_barang').val('');
                            $('#total_harga').val('');
                            $('#harga_akhir').val('');
                        }
                    },
                    error: function() {
                        $('#harga_barang').val('');
                        $('#total_harga').val('');
                        $('#harga_akhir').val('');
                    }
                });
            } else {
                $('#harga_barang').val('');
                $('#total_harga').val('');
                $('#harga_akhir').val('');
            }
        });

        $('#jumlah, #discount').on('input', function() {
            calculateTotalHarga();
        });

        $('#discount').on('input', function() {
            calculateHargaAkhir();
        });
    });
</script>

