#!C:\Users\liman\AppData\Local\Programs\Python\Python311\python.exe
# print("Content-Type: text/html\n")
import io
import logging
import json
import os
from pandas import array
from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.common.action_chains import ActionChains
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from selenium.common.exceptions import TimeoutException, NoSuchElementException, WebDriverException
import time
from selenium.webdriver.chrome.options import Options
from bs4 import BeautifulSoup
from urllib.parse import urlencode
import re
import mysql.connector
import sys
import locale

def format_currency(amount, locale_name='id_ID.UTF-8', symbol=True, grouping=True):
    locale.setlocale(locale.LC_ALL, locale_name)
    return locale.currency(amount, symbol=symbol, grouping=grouping)

sys.stdout = io.TextIOWrapper(sys.stdout.buffer, encoding='utf-8')
# db_config = {   
#                 "host": "34.172.107.253",
#                 "user": "melissa",
#                 "password": "1234",
#                 "database": "dataAnalytics",
#             }
# db_config = {   
#                 "host": "localhost",
#                 "user": "root",
#                 "password": "",
#                 "database": "webApp",
#             }

db_config = {   
                "host": "localhost",
                "port": 3306,
                "user": "melissa",
                "password": "1234",
                "database": "dataAnalytics",
            }

################################################################


class Product:
    # Constructor method (__init__)
    def __init__(self, name, price):
        # Attributes
        self.name = name
        self.price = price

    def display_info(self):
        return f"<tr><td>{self.name}</td><td>Rp {self.price}</td><td><input type='radio' onclick='bindSet(event)' class='options' id='{self.name}' name='{self.name}' value='{self.price}'></td></tr>"
    
    def get_name(self):
        return self.name
    def __eq__(self, other):
        if isinstance(other, Product):
            return self.name == other.name and self.href == other.href
        return False

    def __hash__(self):
        return hash((self.name, self.href))


def convert_sold(sold_str):
    sold_str = sold_str.replace(",", "")  # Remove commas if present
    if "rb+ terjual" in sold_str:
        return int(float(sold_str.replace("rb+ terjual", "")) * 1000)
    else:
        return int(re.search(r"\d+", sold_str).group())


#################################################################
def generate_phrases(product_name, start_index=4):
    words = product_name.split()
    phrases = []
    pool_products = []

    # Ensure the start_index is within the bounds of the words list
    if start_index > len(words):
        start_index = len(words)
    
    # Generate phrases starting from the specified index
    for i in range(start_index, len(words) + 1):
        phrase = ' '.join(words[:i])
        # print(phrase)
        phrases.append(phrase)

    for phrase in phrases:
        scraped_data = scrape_data(phrase)
        if scraped_data is not None:
            pool_products.extend(scraped_data)
    logging.info(len(pool_products))
    return pool_products

def filter_result(products):
    if len(products) > 0:
        total_price = sum(int(product.price) for product in products)
        average_price = total_price / len(products) * 0.7
    else:
        average_price = 0
    
    filtered = [product for product in products if int(product.price) >= average_price]

    sorted_products = sorted(
        filtered, key=lambda x: (x.sold, x.rating, int(x.price)), reverse=True
    )
    
    return sorted_products[:10]

def scrape_data(prdNm):
    # Set up Chrome options
    options = Options()
    options.add_argument("--enable-javascript")
    # options.add_argument("--headless")
    options.add_argument(
        "user-agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36"
    )
    # options.add_argument("--window-position=1920,1080")

    driver = webdriver.Chrome(options=options)        

    varProd_dict = {"st": "", "q": prdNm}
    encoded_data = urlencode(varProd_dict)
    base_url = "https://www.tokopedia.com/search?"
    url = base_url + encoded_data
    
    try:
        # Navigate to the search URL
        driver.get(url)
        time.sleep(10)

        # Wait for the dropdown button to be clickable
        dropdown_button = WebDriverWait(driver, 5).until(
            EC.element_to_be_clickable((By.XPATH, "//button[@data-unify='Select']"))
        )
        dropdown_button.click()

        # Find and click the option for "Ulasan"
        ulasan_option = WebDriverWait(driver, 3).until(
            EC.element_to_be_clickable((By.XPATH, "//button[@data-item-text='Ulasan']"))
        )
        ulasan_option.click()
        time.sleep(5)
        
        lazy_elements = WebDriverWait(driver, 8).until(
            EC.presence_of_all_elements_located((By.CLASS_NAME, "IOLazyloading"))
        )
        last_height = driver.execute_script("return document.body.scrollHeight")

        for _ in range(10):  # Adjust range for sufficient scrolling
            driver.execute_script("window.scrollBy(0, 500);")
            time.sleep(3)  # Adjust wait time as needed

            # Move to lazy-loaded elements
            actions = ActionChains(driver)
            for element in lazy_elements:
                try:
                    actions.move_to_element(element).perform()
                    time.sleep(1)  # Adjust wait time as needed
                except Exception as e:
                    break

            # Calculate new scroll height
            new_height = driver.execute_script("return document.body.scrollHeight")
            if new_height == last_height:
                break
            last_height = new_height

        # Parse the HTML content
        html_content = driver.page_source
        soup = BeautifulSoup(html_content, "html.parser")
        price = soup.select('div.prd_link-product-price[data-testid="spnSRPProdPrice"]')
        name = soup.select('div.prd_link-product-name[data-testid="spnSRPProdName"]')
        href = soup.select("a.pcv3__info-content")
        rate = soup.select("span.prd_rating-average-text")
        soldNu = soup.select("span.prd_label-integrity")
        pic_cons = soup.find_all("div", class_="pcv3_img_container")
        products = []

        # Extract product information
        for x, y, z, m, n, o in zip(name, price, rate, soldNu, href, pic_cons):
            first_three_words = prdNm.lower().split()[:3]
            if all(word in x.text.lower() for word in first_three_words) and convert_sold(m.text.strip()) > 10:
                img_tag = o.find("img")
                if img_tag:
                    img_url = img_tag["src"]
                    newProd = Product(
                        x.text.strip(),
                        re.sub(r"\D", "", y.text.strip()),
                        z.text.strip(),
                        convert_sold(m.text.strip()),
                        n["href"],
                        img_url,
                    )
                    if newProd not in products:
                        products.append(newProd)

        return products if products else []

    except Exception as e:
        # print(f"An exception occurred: {e}")
        pass

    driver.quit()
    return []  # Return an empty list if no products are found or an error occurs

def output_table(bundle_id, prdNm, db_config):
    conn = mysql.connector.connect(**db_config)
    cur = conn.cursor()
    sql = "SELECT * FROM scraperesult WHERE bundle_id = %s AND identifier = %s"
    cur.execute(sql, (bundle_id, prdNm,))
    rows = cur.fetchall()

    html_string = f'''
        <h5>Result for : {prdNm}</h5>
        <table class="table table-bordered" id="{prdNm}">
            <thead>
                <tr>
                    <th>Gambar</th>
                    <th>Nama Produk</th>
                    <th>Harga</th>
                    <th>Rating</th>
                    <th>Terjual</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
    '''

    for row in rows:
        html_string += f'''
            <tr>
                <td><img src='{row[1]}'></td>
                <td><a href="{row[2]}">{row[3]}</a></td>
                <td>{row[4]}</td>
                <td>{row[5]}</td>
                <td>{row[6]}</td>
                <td><input type='radio' onclick='bindSet(event)' class='options' id='{row[0]}' name='{row[0]}' value='{row[4]}'></td>
            </tr>
        '''

    html_string += '''
            </tbody>
        </table><br><br>
    '''
    
    print(html_string)


# Function to read JSON data from a file
def read_json_file(file_path):
    if os.path.exists(file_path):
        with open(file_path, "r") as json_file:
            try:
                return json.load(json_file)
            except json.JSONDecodeError:
                return []
    return []  # Return an empty list if the file doesn't exist or is empty

# Function to write JSON data to a file
def write_json_file(file_path, data):
    with open(file_path, "w") as json_file:
        json.dump(data, json_file, indent=4)

combined_results = []
prdArr = []
logging.basicConfig(level=logging.INFO) 
if (len(sys.argv) > 1):
    try:
        value_from_php = sys.argv[1]
        sorted_prd = ''
        valuess = value_from_php.split(",")
        bundle_id, shop_id = valuess
        conn = mysql.connector.connect(**db_config)
        cur = conn.cursor()
        sql = "SELECT antecedent, consequent FROM bundleitems WHERE id = %s"
        cur.execute(sql, (bundle_id,))
        rows = cur.fetchall()
        for antecedent, consequent in rows:
            antecedent_items = antecedent.split(" => ")
            if " || " in antecedent_items[0]:
                antecedents = antecedent_items[0].split(" || ")
                for i in antecedents:
                    prdArr.append(i)
            else:
                prdArr.append(antecedent_items[0])

            if " || " in consequent:
                consequents = consequent.split(" || ")
                for i in consequents:
                    prdArr.append(i)
            else:
                prdArr.append(consequent)
                
        items = []
        for i in prdArr:
            name = i
            sql = "SELECT DISTINCT quantity, gross_revenue FROM orders_report WHERE nama_produk = %s"
            cur.execute(sql, (i,))
            rows = cur.fetchall()
            name = i

            # Iterating through the fetched rows and printing quantity and gross revenue
            for row in rows:
                qty, totalprice = row  # Each row is a tuple containing (quantity, gross_revenue)
                price = int(totalprice/qty)
                items.append(Product(i, price))
                break

        for i in items :
            html_string = f'''
            <h5>Result for : {i.get_name()} </h5>
            <table class="table table-bordered" id="{i.get_name()}">
                <thead>
                    <tr>
                        <th>Nama Produk</th>
                        <th>Harga</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
            '''
            print(html_string)
            print(i.display_info())
            print('</tbody></table><br><br>')
    except KeyboardInterrupt:
        print("\nProgram interrupted and stopped.")
    # for i in prdArr:
    #     output_table(bundle_id, i, db_config)
